<?php
/**
 * Title: Portfolio
 * Slug: themepalace-fse/portfolio
 * Categories: themepalace-fse
 *
 * @package themepalace-fse
 * @since 1.0.0
 */
?>

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"90px","bottom":"90px"}},"color":{"background":"#f5f5f5"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-background" style="background-color:#f5f5f5;padding-top:90px;padding-bottom:90px"><!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"40px"}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignwide"><!-- wp:group {"className":"tp-fse-section-header","style":{"spacing":{"blockGap":"var:preset|spacing|20","margin":{"bottom":"60px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group tp-fse-section-header" style="margin-bottom:60px"><!-- wp:paragraph {"align":"center","className":"tp-fse-section-subtitle","style":{"typography":{"fontSize":"18px"},"elements":{"link":{"color":{"text":"var:preset|color|secondary"}}}},"textColor":"secondary"} -->
<p class="has-text-align-center tp-fse-section-subtitle has-secondary-color has-text-color has-link-color" style="font-size:18px"><strong><?php echo esc_html__( 'Our  Portfolio', 'themepalace-fse' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"center","className":"tp-fse-section-title","style":{"typography":{"fontSize":"35px"}}} -->
<h2 class="wp-block-heading has-text-align-center tp-fse-section-title" style="font-size:35px"><?php echo esc_html__( 'Some of our finest work.', 'themepalace-fse' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"18px"}}} -->
<p class="has-text-align-center" style="font-size:18px"><?php echo esc_html__( 'You can manage it from Services section in Theme Customizer.', 'themepalace-fse' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"blockGap":"0"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull"><!-- wp:columns {"align":"full","style":{"spacing":{"blockGap":{"left":"40px"},"margin":{"top":"0","bottom":"0"}}}} -->
<div class="wp-block-columns alignfull" style="margin-top:0;margin-bottom:0"><!-- wp:column {"width":"33.33%","layout":{"type":"default"}} -->
<div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:group {"style":{"border":{"radius":"30px","color":"#d8d8d8","width":"2px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color" style="border-color:#d8d8d8;border-width:2px;border-radius:30px"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-one.jpg","id":33,"dimRatio":0,"customOverlayColor":"#3d4249","isUserOverlayColor":false,"minHeight":300,"minHeightUnit":"px","style":{"border":{"radius":{"topLeft":"30px","topRight":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover" style="border-top-left-radius:30px;border-top-right-radius:30px;min-height:300px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#3d4249"></span><img class="wp-block-cover__image-background wp-image-33" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-one.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"right":"30px","left":"30px","bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:heading {"style":{"typography":{"fontSize":"25px"}}} -->
<h2 class="wp-block-heading" style="font-size:25px"><?php echo esc_html__( 'Web Application', 'themepalace-fse' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Branding', 'themepalace-fse' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'Logo', 'themepalace-fse' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'Mobile App', 'themepalace-fse' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.33%","layout":{"type":"default"}} -->
<div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:group {"style":{"border":{"radius":"30px","color":"#d8d8d8","width":"2px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color" style="border-color:#d8d8d8;border-width:2px;border-radius:30px"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-two.jpg","id":36,"dimRatio":0,"customOverlayColor":"#e6d3ca","isUserOverlayColor":false,"minHeight":300,"minHeightUnit":"px","isDark":false,"style":{"border":{"radius":{"topLeft":"30px","topRight":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light" style="border-top-left-radius:30px;border-top-right-radius:30px;min-height:300px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#e6d3ca"></span><img class="wp-block-cover__image-background wp-image-36" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-two.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"right":"30px","left":"30px","bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:heading {"style":{"typography":{"fontSize":"25px"}}} -->
<h2 class="wp-block-heading" style="font-size:25px"><?php echo esc_html__( 'Digital Agency', 'themepalace-fse' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Branding', 'themepalace-fse' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'IOS App,', 'themepalace-fse' ); ?>&nbsp;<?php echo esc_html__( 'UI/UX', 'themepalace-fse' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.33%","layout":{"type":"default"}} -->
<div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:group {"style":{"border":{"radius":"30px","color":"#d8d8d8","width":"2px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color" style="border-color:#d8d8d8;border-width:2px;border-radius:30px"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-three.jpg","id":35,"dimRatio":0,"customOverlayColor":"#4f4d73","isUserOverlayColor":false,"minHeight":300,"minHeightUnit":"px","style":{"border":{"radius":{"topLeft":"30px","topRight":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover" style="border-top-left-radius:30px;border-top-right-radius:30px;min-height:300px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#4f4d73"></span><img class="wp-block-cover__image-background wp-image-35" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-three.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"right":"30px","left":"30px","bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:heading {"style":{"typography":{"fontSize":"25px"}}} -->
<h2 class="wp-block-heading" style="font-size:25px"><?php echo esc_html__( 'Plan Managment', 'themepalace-fse' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Branding', 'themepalace-fse' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'Mobile App', 'themepalace-fse' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"full","style":{"spacing":{"blockGap":{"left":"40px"},"margin":{"top":"30px","bottom":"0"}}}} -->
<div class="wp-block-columns alignfull" style="margin-top:30px;margin-bottom:0"><!-- wp:column {"width":"33.33%","layout":{"type":"default"}} -->
<div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:group {"style":{"border":{"radius":"30px","color":"#d8d8d8","width":"2px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color" style="border-color:#d8d8d8;border-width:2px;border-radius:30px"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-four.jpg","id":39,"dimRatio":0,"customOverlayColor":"#28282a","isUserOverlayColor":false,"minHeight":300,"minHeightUnit":"px","style":{"border":{"radius":{"topLeft":"30px","topRight":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover" style="border-top-left-radius:30px;border-top-right-radius:30px;min-height:300px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#28282a"></span><img class="wp-block-cover__image-background wp-image-39" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-four.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"right":"30px","left":"30px","bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:heading {"style":{"typography":{"fontSize":"25px"}}} -->
<h2 class="wp-block-heading" style="font-size:25px"><?php echo esc_html__( 'Creative Application', 'themepalace-fse' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Branding', 'themepalace-fse' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'Logo', 'themepalace-fse' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'Mobile App', 'themepalace-fse' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.33%","layout":{"type":"default"}} -->
<div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:group {"style":{"border":{"radius":"30px","color":"#d8d8d8","width":"2px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color" style="border-color:#d8d8d8;border-width:2px;border-radius:30px"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-five.jpg","id":38,"dimRatio":0,"customOverlayColor":"#2d2640","isUserOverlayColor":false,"minHeight":300,"minHeightUnit":"px","style":{"border":{"radius":{"topLeft":"30px","topRight":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover" style="border-top-left-radius:30px;border-top-right-radius:30px;min-height:300px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#2d2640"></span><img class="wp-block-cover__image-background wp-image-38" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-five.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"right":"30px","left":"30px","bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:heading {"style":{"typography":{"fontSize":"25px"}}} -->
<h2 class="wp-block-heading" style="font-size:25px"><?php echo esc_html__( 'Web Agency', 'themepalace-fse' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Branding', 'themepalace-fse' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'IOS App,', 'themepalace-fse' ); ?>&nbsp;<?php echo esc_html__( 'UI/UX', 'themepalace-fse' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.33%","layout":{"type":"default"}} -->
<div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:group {"style":{"border":{"radius":"30px","color":"#d8d8d8","width":"2px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color" style="border-color:#d8d8d8;border-width:2px;border-radius:30px"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-six.jpg","id":37,"dimRatio":0,"customOverlayColor":"#625f97","isUserOverlayColor":false,"minHeight":300,"minHeightUnit":"px","style":{"border":{"radius":{"topLeft":"30px","topRight":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover" style="border-top-left-radius:30px;border-top-right-radius:30px;min-height:300px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#625f97"></span><img class="wp-block-cover__image-background wp-image-37" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/portfolio-six.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"right":"30px","left":"30px","bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:heading {"style":{"typography":{"fontSize":"25px"}}} -->
<h2 class="wp-block-heading" style="font-size:25px"><?php echo esc_html__( 'Graphics Design', 'themepalace-fse' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Branding', 'themepalace-fse' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'Design , Development', 'themepalace-fse' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->