<?php

/**
 * Title: Project
 * Slug: themepalace-business/project
 * Categories: themepalace-business
 *
 * @package themepalace-business
 * @since 1.0.0
 */
?>


<!-- wp:group {"align":"full","className":"project-section","style":{"spacing":{"padding":{"top":"90px","bottom":"90px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull project-section" style="padding-top:90px;padding-bottom:90px"><!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"40px"}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignwide"><!-- wp:group {"className":"tp-fse-section-header","style":{"spacing":{"blockGap":"var:preset|spacing|20","margin":{"bottom":"60px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group tp-fse-section-header" style="margin-bottom:60px"><!-- wp:paragraph {"align":"center","className":"tp-fse-section-subtitle","style":{"typography":{"fontSize":"18px","letterSpacing":"2px"},"elements":{"link":{"color":{"text":"var:preset|color|primary"}}}},"textColor":"primary"} -->
<p class="has-text-align-center tp-fse-section-subtitle has-primary-color has-text-color has-link-color" style="font-size:18px;letter-spacing:2px"><strong><?php echo esc_html__( 'Projects', 'themepalace-business' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"center","className":"tp-fse-section-title","style":{"typography":{"fontSize":"60px"}}} -->
<h2 class="wp-block-heading has-text-align-center tp-fse-section-title" style="font-size:60px"><?php echo esc_html__( 'Completed Cases', 'themepalace-business' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"18px"}}} -->
<p class="has-text-align-center" style="font-size:18px"><?php echo esc_html__( 'You can manage it from site editor.', 'themepalace-business' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"blockGap":"0"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull"><!-- wp:columns {"align":"wide"} -->
<div class="wp-block-columns alignwide"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"0px","color":"#d8d8d8","width":"2px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color" style="border-color:#d8d8d8;border-width:2px;border-radius:0px"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/image-four.jpg","dimRatio":0,"customOverlayColor":"#b0a7a2","isUserOverlayColor":false,"minHeight":300,"minHeightUnit":"px","isDark":false,"sizeSlug":"large","style":{"border":{"radius":"0px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light" style="border-radius:0px;min-height:300px"><img class="wp-block-cover__image-background  size-large" alt="" src="<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/image-four.jpg" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#b0a7a2"></span><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"right":"30px","left":"30px","bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:heading {"style":{"typography":{"fontSize":"25px"}}} -->
<h2 class="wp-block-heading" style="font-size:25px"><?php echo esc_html__( 'Business Planning', 'themepalace-business' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Branding', 'themepalace-business' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'Business Planning', 'themepalace-business' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"0px","color":"#d8d8d8","width":"2px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color" style="border-color:#d8d8d8;border-width:2px;border-radius:0px"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/image-five.jpg","dimRatio":0,"customOverlayColor":"#ac9d93","isUserOverlayColor":false,"minHeight":300,"minHeightUnit":"px","isDark":false,"sizeSlug":"large","style":{"border":{"radius":"0px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light" style="border-radius:0px;min-height:300px"><img class="wp-block-cover__image-background size-large" alt="" src="<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/image-five.jpg" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#ac9d93"></span><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"right":"30px","left":"30px","bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:heading {"style":{"typography":{"fontSize":"25px"}}} -->
<h2 class="wp-block-heading" style="font-size:25px"><?php echo esc_html__( 'Market Research', 'themepalace-business' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Branding', 'themepalace-business' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'Market Analysis', 'themepalace-business' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"0px","color":"#d8d8d8","width":"2px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color" style="border-color:#d8d8d8;border-width:2px;border-radius:0px"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/image-six.jpg","dimRatio":0,"customOverlayColor":"#9d9895","isUserOverlayColor":false,"minHeight":300,"minHeightUnit":"px","isDark":false,"sizeSlug":"large","style":{"border":{"radius":"0px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light" style="border-radius:0px;min-height:300px"><img class="wp-block-cover__image-background  size-large" alt="" src="<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/image-six.jpg" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#9d9895"></span><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","placeholder":"Write title…","fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size"></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"right":"30px","left":"30px","bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:heading {"style":{"typography":{"fontSize":"25px"}}} -->
<h2 class="wp-block-heading" style="font-size:25px"><?php echo esc_html__( 'Web Application', 'themepalace-business' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Branding', 'themepalace-business' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'Logo', 'themepalace-business' ); ?>&nbsp;,&nbsp;<?php echo esc_html__( 'Mobile App', 'themepalace-business' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->