<?php
// Example values (you'll pass these dynamically, e.g. from $_POST)
$user_email       = $_GET['email'];
$activation_code  = $_GET['verify_nonce'];

// Query CPT "vcard_profile" using email + activation_code
$args = array(
    'post_type'      => 'vcard_profile',
    'post_status'    => 'publish',
    'meta_query'     => array(
        'relation' => 'AND',
        array(
            'key'     => 'email',
            'value'   => $user_email,
            'compare' => '=',
        ),
        array(
            'key'     => 'activation_code',
            'value'   => $activation_code,
            'compare' => '=',
        ),
        array(
            'key'     => 'status',
            'value'   => '1',
            'compare' => '=',
        ),
    ),
    'posts_per_page' => 1, // return only one match
);

$query = new WP_Query( $args );

// Check result
if ( $query->have_posts() ) {
    while ( $query->have_posts() ) {
        $query->the_post();
        // echo '<h3>Matched Profile: ' . get_the_title() . '</h3>';
        // echo '<p>Email: ' . get_post_meta( get_the_ID(), 'email', true ) . '</p>';
        // echo '<p>Activation Code: ' . get_post_meta( get_the_ID(), 'activation_code', true ) . '</p>';

        $post_id = get_the_ID();
		$update_status = update_post_meta( $post_id, 'status', '2' );
        $slug = get_post_field( 'post_name', $post_id );

        if ($update_status) {

            // Generate a random password
            $password = wp_generate_password( 12, true );

            // Extract username from email (before @)
            $username = sanitize_user( $slug );

            // Make sure username is unique
            // $username = wp_unique_username( $username );

            // Prepare user data
            $userdata = array(
                'user_login' => $username,
                'user_pass'  => $password,
                'user_email' => $user_email,
                'role'       => 'author', // Change role if needed
            );

            // Insert user
            $user_id = wp_insert_user( $userdata );
		    $update_status = update_post_meta( $post_id, 'account', $user_id );

            // Update post author
            $updated_post = array(
                'ID'          => $post_id,
                'post_author' => $user_id,
            );

            $new_author = wp_update_post( $updated_post );
            
            $to = $user_email;
            $subject = "iTap | Your Account is Created";
        
            
            $email_logo = get_home_url() . '/wp-content/uploads/2025/09/logo-itap.png';
            $email_name = ', <em>'.$username.'</em>';
            $welcome_msg = 'Welcome to iTap, your virtual business card soultion.<br/>Let’s get you started!';

            $cta_msg = '<p>We’re excited to have you on board! You’ve just taken the first step toward smarter, paperless networking with iTap.</p><p>We’ve provided you with a temporary password below. For your security, we highly recommend updating it to a new one immediately after logging in.</p>';

            $temp_pw = $password;
            $headers[] = 'Content-type: text/html; charset=utf-8';

            ob_start();
            include('email/account_create.php');
            $message = ob_get_contents();
            ob_end_clean();

            $results = wp_mail($to, $subject, $message, $headers);

            if ($user_id && $update_status && $results && $new_author) {

                echo "<div class='success text-white'>Account Successfully Verified! We’ve sent your login credentials straight to your inbox, check your email and get ready to access your profile.</div>";

            } else {
                echo "<div class='error text-white  text-white'>We’re sorry, your request can't be completed. Please don’t hesitate to contact us at  
        <a href='mailto:admin@teleworkx.ai' style='color:#fff; font-weight:bold;'>admin@teleworkx.ai</a> and we’ll be happy to assist you right away.</div>";
            }

        } else {
            echo "<div class='error text-white  text-white'>We’re sorry, your request can't be proccessed. Please don’t hesitate to contact us at  
    <a href='mailto:admin@teleworkx.ai' style='color:#fff; font-weight:bold;'>admin@teleworkx.ai</a> and we’ll be happy to assist you right away.</div>";
        }


        
    }
    wp_reset_postdata();
} else {
    echo "<div class='error text-white  text-white'>We’re sorry, something went wrong. Please don’t hesitate to contact us at  
    <a href='mailto:admin@teleworkx.ai' style='color:#fff; font-weight:bold;'>admin@teleworkx.ai</a> and we’ll be happy to assist you right away.</div>";
}
