(function( $ ) {
	'use strict';

	/**
	 * All of the code for your public-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	$(function() {
		console.log('TEST: '+ ajax_object.ajax_url );

		$("#contactForm").on("submit", function (e) {
			e.preventDefault();
		
			$.ajax({
			  url: ajax_object.ajax_url,
			  type: "POST",
			  data: {
				action: "submit_contact_form",
				email: $("input[name='email']").val(),
			  },
			  beforeSend: function () {
				$("#formResponse").html('<p><img src="https://ilabs-itsolutions.com/~vcard/wp-content/uploads/2025/09/icons8-cogs.gif" style="vertical-align: middle;"/>Processing your request..</p>');
			  },
			  success: function (response) {
				$("#formResponse").html(response);
				// $("#contactForm")[0].reset();
			  },
			  error: function (response) {
				console.log(response);
				$("#formResponse").html("Error. Please try again.");
			  },
			});
		  });
	});

})( jQuery );
