<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://ilabs-itsolutions.com
 * @since      1.0.0
 *
 * @package    Itap_Vcard_Generator
 * @subpackage Itap_Vcard_Generator/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Itap_Vcard_Generator
 * @subpackage Itap_Vcard_Generator/public
 * @author     iLabs IT Solutions <hello@ilabs-itsolutions.com>
 */
class Itap_Vcard_Generator_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Itap_Vcard_Generator_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Itap_Vcard_Generator_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/itap-vcard-generator-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Itap_Vcard_Generator_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Itap_Vcard_Generator_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/itap-vcard-generator-public.js', array( 'jquery' ), $this->version, false );
		wp_localize_script( $this->plugin_name, 'ajax_object', ['ajax_url' => admin_url('admin-ajax.php')] );

	}

	/*
	VCard Generator Shortcodes
	*/
	public function register_shortcodes() {
		ob_start();
		include 'partials/vcard-signup-form.php';
		return ob_get_clean();
	}

	public function handle_signup_form() {
		$email   = sanitize_email($_POST['email']);

		$post_title = strstr($email, '@', true);
		
		$headers[] = 'Content-type: text/html; charset=utf-8';

		$existing_posts = get_posts( array(
			'post_type'      => 'vcard_profile',
			'title'          => $post_title,
			'post_status'    => array( 'publish', 'pending', 'draft', 'future', 'private' ), // Include all relevant statuses
			// 'exclude'        => array( $post_id ), // Exclude the current post being saved
			'posts_per_page' => 1,
			'fields'         => 'ids', // Only retrieve IDs for efficiency
		) );

		if ( ! empty( $existing_posts ) ) {

			echo "<div class='error text-white'>We’re sorry, we can't proceed to process your request. Please don’t hesitate to contact us at <a href='mailto:admin@teleworkx.ai' style='color:#fff; font-weight:bold;'>admin@teleworkx.ai</a> and we’ll be happy to assist you right away.</div>";

		} else {

			$to = $email;
			$subject = "iTap | Verify Your Account";
			$activation_code = md5($post_title.$post_id);
		
			
			$email_logo = get_home_url() . '/wp-content/uploads/2025/09/logo-itap.png';
			$email_name = ', <em>'.$post_title.'</em>';
			$welcome_msg = 'Welcome to iTap, your virtual business card soultion.<br/>Let’s get you started!';

			$cta_msg = '<p>We’re excited to have you on board! You’ve just taken the first step toward smarter, paperless networking with iTap.</p><p>Before you can explore your new virtual business card, we need to confirm your email address. This helps us keep your account secure and ensures you don’t miss important updates.</p>';
			$cta_link = get_permalink(11).'?verify_nonce='.$activation_code.'&email='.$to;
			$cta_label = 'Verify Your Account';

			ob_start();
			include('partials/email/verification.php');
			$message = ob_get_contents();
			ob_end_clean();


			// 1. Create post object
			$new_post = array(
				'post_title'    => $post_title,
				'post_content'  => '',
				'post_status'   => 'publish',  // or 'draft'
				'post_type'     => 'vcard_profile', // <-- change to your CPT slug
			);
		
			// 2. Insert post into database
			$post_id = wp_insert_post($new_post);

			if ($post_id) {

				update_post_meta( $post_id, 'status', '1' );
				update_post_meta( $post_id, 'activation_code',  $activation_code);
				update_post_meta( $post_id, 'email',  $to);

				$results = wp_mail($to, $subject, $message, $headers);

				if ($results) {
					echo "<div class='success text-white'>You’re in! Check your email to start building your iTap Profile today.</div>";
				} else {
					echo "<div class='error text-white'>We’re sorry, something went wrong while processing your request. Please don’t hesitate to contact us at  
					<a href='mailto:admin@teleworkx.ai' style='color:#fff; font-weight:bold;'>admin@teleworkx.ai</a> and we’ll be happy to assist you right away.</div>";
				}
				
			} else {
				echo "<div class='error text-white  text-white'>We’re sorry, your request can't be proccessed. Please don’t hesitate to contact us at  
					<a href='mailto:admin@teleworkx.ai' style='color:#fff; font-weight:bold;'>admin@teleworkx.ai</a> and we’ll be happy to assist you right away.</div>";
			}
		}

		wp_die(); // always include this in AJAX
	}

	public function register_shortcodes_verify() {
		ob_start();
		include 'partials/vcard-process-verification.php';
		return ob_get_clean();
	}

}
