<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://ilabs-itsolutions.com
 * @since             1.0.0
 * @package           Itap_Vcard_Generator
 *
 * @wordpress-plugin
 * Plugin Name:       iTap - VCard Generator
 * Plugin URI:        https://ilabs-itsolutions.com
 * Description:       This is a description of the plugin.
 * Version:           1.0.0
 * Author:            iLabs IT Solutions
 * Author URI:        https://ilabs-itsolutions.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       itap-vcard-generator
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'ITAP_VCARD_GENERATOR_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-itap-vcard-generator-activator.php
 */
function activate_itap_vcard_generator() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-itap-vcard-generator-activator.php';
	Itap_Vcard_Generator_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-itap-vcard-generator-deactivator.php
 */
function deactivate_itap_vcard_generator() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-itap-vcard-generator-deactivator.php';
	Itap_Vcard_Generator_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_itap_vcard_generator' );
register_deactivation_hook( __FILE__, 'deactivate_itap_vcard_generator' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-itap-vcard-generator.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_itap_vcard_generator() {

	$plugin = new Itap_Vcard_Generator();
	$plugin->run();

}
run_itap_vcard_generator();
