<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://ilabs-itsolutions.com
 * @since      1.0.0
 *
 * @package    Itap_Vcard_Generator
 * @subpackage Itap_Vcard_Generator/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Itap_Vcard_Generator
 * @subpackage Itap_Vcard_Generator/includes
 * @author     iLabs IT Solutions <hello@ilabs-itsolutions.com>
 */
class Itap_Vcard_Generator_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'itap-vcard-generator',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
