<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://ilabs-itsolutions.com
 * @since      1.0.0
 *
 * @package    Itap_Vcard_Generator
 * @subpackage Itap_Vcard_Generator/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Itap_Vcard_Generator
 * @subpackage Itap_Vcard_Generator/admin
 * @author     iLabs IT Solutions <hello@ilabs-itsolutions.com>
 */
class Itap_Vcard_Generator_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Itap_Vcard_Generator_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Itap_Vcard_Generator_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/itap-vcard-generator-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Itap_Vcard_Generator_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Itap_Vcard_Generator_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/itap-vcard-generator-admin.js', array( 'jquery' ), $this->version, false );

	}

	/*
	Add admin menu to WP-ADMIN
	*/
	public function add_menu() {
        // add_menu_page( $page_title, $menu_title, $capability, $menu_slug, $function, $icon_url, $position );
        add_menu_page( "VCard Generator", "VCard Generator", 'manage_options', $this->plugin_name . '-vcard-generator', array( $this, 'vcard_generator' ), 'dashicons-id', 72);
    }

	public function vcard_generator() {
        include( plugin_dir_path( __FILE__ ) . 'partials/vcard_generator.php' );
    }

	public function custom_endpoints() {
        register_rest_route( 'itap/v2', '/card-data/(?P<id>\\d+)', array(
			'methods'  => 'GET',
            'callback' => array( $this, 'card_data_info' ),
            'args'     => array(
                'id' => array(
                    'validate_callback' => function( $param, $request, $key ) {
                        return is_numeric( $param );
                    }
                ),
            ),
		) );
    }

	public function card_data_info($request){

		$id = $request['id']; // Access the 'id' parameter from the URL
		$status = '200';

		if ($id == 1) {

			$msg = array(
					'theme' => 'modern#1',
					'color' => 'candyland',
					'name' => 'José Protacio Rizal Mercado y Alonso Realonda',
					'picture' => 'https://ilabs-itsolutions.com/~vcard/wp-content/uploads/2025/09/rizal.jpeg',
					'bio' => 'Ang hindi magmahal sa sariling wika ay higit sa hayop at malansang isda!',
					'bg_pic' => 'https://ilabs-itsolutions.com/~vcard/wp-content/uploads/2025/09/ink_paper.jpeg',
					'links' => array (
						array(
							'name' => 'LinkedIn',
							'icon' => 'https://ilabs-itsolutions.com/~vcard/wp-content/uploads/2025/09/icons8-linkedin-50.png',
							'link' => 'www.linkedin.com',
						),
						array(
							'name' => 'Facebook',
							'icon' => 'https://ilabs-itsolutions.com/~vcard/wp-content/uploads/2025/09/icons8-facebook-50.png',
							'link' => 'www.linkedin.com',
						),
						array(
							'name' => 'PrimaryContact',
							'icon' => 'https://ilabs-itsolutions.com/~vcard/wp-content/uploads/2025/09/icons8-phone-50.png',
							'link' => '09181234567',
						),
						array(
							'name' => 'Website',
							'icon' => 'https://ilabs-itsolutions.com/~vcard/wp-content/uploads/2025/09/icons8-website-50.png',
							'link' => 'www.ilabs-itsolutions.com',
						),
					),
				);

		} else if ($id == 2) {
			
			$msg = array(
				'theme' => 'modern#2',
				'color' => 'darkmode',
				'name' => 'General Antonio Luna de San Pedro y Novicio-Ancheta',
				'picture' => 'https://ilabs-itsolutions.com/~vcard/wp-content/uploads/2025/09/gen3-antonio-luna_2019-08-25_22-33-52.jpg',
				'bio' => 'Negosyo o kalayaan? Bayan o sarili? Pumili ka!',
				'links' => array (
					array(
						'name' => 'LinkedIn',
						'icon' => 'https://ilabs-itsolutions.com/~vcard/wp-content/uploads/2025/09/icons8-linkedin-50.png',
						'link' => 'www.linkedin.com',
					),
					array(
						'name' => 'PrimaryContact',
						'icon' => 'https://ilabs-itsolutions.com/~vcard/wp-content/uploads/2025/09/icons8-phone-50.png',
						'link' => '09154446667',
					)
				),
			);

		} else {
			$msg = 'Error retrieving data, please try again';
			$status = '404';
		}

		// Perform actions based on the $id, e.g., fetch data from the database
        $response_data = array(
            'message' => $msg,
            'status'  => $status,
        );

        return new WP_REST_Response( $response_data, 200 );

	}

	public function cpt_vcard_profile() {
	
		$labels = array(
			'name'                  => _x( 'VCard Profiles', 'Post Type General Name', 'vcard_profile' ),
			'singular_name'         => _x( 'VCard Profile', 'Post Type Singular Name', 'vcard_profile' ),
			'menu_name'             => __( 'VCard Profile', 'vcard_profile' ),
			'name_admin_bar'        => __( 'VCard Profile', 'vcard_profile' ),
			'archives'              => __( 'Item Archives', 'vcard_profile' ),
			'attributes'            => __( 'Item Attributes', 'vcard_profile' ),
			'parent_item_colon'     => __( 'Parent Item:', 'vcard_profile' ),
			'all_items'             => __( 'All Items', 'vcard_profile' ),
			'add_new_item'          => __( 'Add New Item', 'vcard_profile' ),
			'add_new'               => __( 'Add New', 'vcard_profile' ),
			'new_item'              => __( 'New Item', 'vcard_profile' ),
			'edit_item'             => __( 'Edit Item', 'vcard_profile' ),
			'update_item'           => __( 'Update Item', 'vcard_profile' ),
			'view_item'             => __( 'View Item', 'vcard_profile' ),
			'view_items'            => __( 'View Items', 'vcard_profile' ),
			'search_items'          => __( 'Search Item', 'vcard_profile' ),
			'not_found'             => __( 'Not found', 'vcard_profile' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'vcard_profile' ),
			'featured_image'        => __( 'Featured Image', 'vcard_profile' ),
			'set_featured_image'    => __( 'Set featured image', 'vcard_profile' ),
			'remove_featured_image' => __( 'Remove featured image', 'vcard_profile' ),
			'use_featured_image'    => __( 'Use as featured image', 'vcard_profile' ),
			'insert_into_item'      => __( 'Insert into item', 'vcard_profile' ),
			'uploaded_to_this_item' => __( 'Uploaded to this item', 'vcard_profile' ),
			'items_list'            => __( 'Items list', 'vcard_profile' ),
			'items_list_navigation' => __( 'Items list navigation', 'vcard_profile' ),
			'filter_items_list'     => __( 'Filter items list', 'vcard_profile' ),
		);
		$args = array(
			'label'                 => __( 'VCard Profile', 'vcard_profile' ),
			'description'           => __( 'VCard Profile', 'vcard_profile' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'revisions', 'thumbnail', 'author' ),
			'taxonomies'            => array( 'category', 'post_tag' ),
			'hierarchical'          => false,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 70,
			'menu_icon'             => 'dashicons-nametag',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => true,
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
		);
		register_post_type( 'vcard_profile', $args );
	
	}

}
